/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.moremousetweaks.MoreMouseTweaks;
import dev.terminalmc.moremousetweaks.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "moremousetweaks.json";
    private static final String BACKUP_FILE_NAME = "moremousetweaks.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    private static int unbox(@Nullable Integer val) {
        return val != null ? val : 0;
    }

    private void validate() {
        this.options.interactionIntervalMp = Options.interactionIntervalValidator.validate(this.options.interactionIntervalMp);
        this.options.interactionIntervalSp = Options.interactionIntervalValidator.validate(this.options.interactionIntervalSp);
        this.options.hotbarScope = Options.hotbarScopeValidator.validate(this.options.hotbarScope);
        this.options.extraSlotScope = Options.extraSlotScopeValidator.validate(this.options.extraSlotScope);
        this.options.typeMatchTags = Options.typeMatchTagsValidator.validate(this.options.typeMatchTags);
        this.options.qcSingleCraftMode = Options.qcSingleCraftModeValidator.validate(this.options.qcSingleCraftMode);
        this.options.dropKey = Options.keyValidator.validate(this.options.dropKey);
        this.options.matchingSlotsKey = Options.keyValidator.validate(this.options.matchingSlotsKey);
    }

    private void upgradeLegacy() {
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0])) {
            config = Config.load(file, GSON);
            if (config == null) {
                Config.backup();
                MoreMouseTweaks.LOG.warn("Resetting config", new Object[0]);
            } else {
                config.upgradeLegacy();
            }
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MoreMouseTweaks.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            MoreMouseTweaks.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            MoreMouseTweaks.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            MoreMouseTweaks.afterConfigSaved(instance);
        }
        catch (IOException e) {
            MoreMouseTweaks.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final int INTERACTION_INTERVAL_MIN = 1;
        public static final int INTERACTION_INTERVAL_MAX = 100;
        public static Validator<Integer> interactionIntervalValidator = val -> Math.clamp((long)Config.unbox(val), 1, 100);
        public static final int interactionIntervalMpDefault = 5;
        public int interactionIntervalMp = 5;
        public static final int interactionIntervalSpDefault = 1;
        public int interactionIntervalSp = 1;
        public static final HotbarScope hotbarScopeDefault = HotbarScope.HOTBAR;
        public HotbarScope hotbarScope = hotbarScopeDefault;
        public static Validator<HotbarScope> hotbarScopeValidator = val -> val != null && Arrays.stream(HotbarScope.values()).toList().contains(val) ? val : hotbarScopeDefault;
        public static final ExtraSlotScope extraSlotScopeDefault = ExtraSlotScope.EXTRA;
        public ExtraSlotScope extraSlotScope = extraSlotScopeDefault;
        public static Validator<ExtraSlotScope> extraSlotScopeValidator = val -> val != null && Arrays.stream(ExtraSlotScope.values()).toList().contains(val) ? val : extraSlotScopeDefault;
        public static final boolean alwaysMatchByTypeDefault = false;
        public boolean alwaysMatchByType = false;
        public static final Supplier<List<String>> typeMatchTagsDefault = () -> List.of("enchantable/weapon", "enchantable/mining", "enchantable/armor");
        public List<String> typeMatchTags = typeMatchTagsDefault.get();
        public static Validator<List<String>> typeMatchTagsValidator = val -> val != null ? val : typeMatchTagsDefault.get();
        public final transient HashSet<class_1792> typeMatchItemCache = new HashSet();
        public static final boolean scrollCreativeTabsDefault = true;
        public boolean scrollCreativeTabs = true;
        public static final boolean scrollRecipeBookTabsDefault = true;
        public boolean scrollRecipeBookTabs = true;
        public static final boolean scrollRecipeBookPagesDefault = true;
        public boolean scrollRecipeBookPages = true;
        public static final boolean useQuickCraftingDefault = true;
        public boolean useQuickCrafting = true;
        public static final QcSingleCraftMode qcSingleCraftModeDefault = QcSingleCraftMode.CURSOR_INVENTORY;
        public QcSingleCraftMode qcSingleCraftMode = qcSingleCraftModeDefault;
        public static Validator<QcSingleCraftMode> qcSingleCraftModeValidator = val -> val != null && Arrays.stream(QcSingleCraftMode.values()).toList().contains(val) ? val : qcSingleCraftModeDefault;
        public static final boolean useQuickTradingDefault = true;
        public boolean useQuickTrading = true;
        public static Validator<Integer> keyValidator = val -> Math.max(Config.unbox(val), -1);
        public static final int dropKeyDefault = 342;
        public int dropKey = 342;
        public static final int matchingSlotsKeyDefault = 341;
        public int matchingSlotsKey = 341;

        public static enum HotbarScope {
            HOTBAR,
            INVENTORY,
            NONE;

        }

        public static enum ExtraSlotScope {
            EXTRA,
            HOTBAR,
            INVENTORY,
            NONE;

        }

        public static enum QcSingleCraftMode {
            CURSOR,
            CURSOR_INVENTORY,
            INVENTORY;

        }
    }

    @FunctionalInterface
    public static interface Validator<T> {
        @NotNull
        public T validate(@Nullable T var1);
    }
}

